﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class ExerciseAvatar : PI.FM.N000.Base.BL.DBD.BaseTable<BO.ExerciseAvatar>
    {
        #region Static factory
        private static ExerciseAvatar _factory = null;

        public static ExerciseAvatar DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new ExerciseAvatar();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_ExerciseAvatar";
        }

        protected override void InitializeProperties()
        {

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ExerciseTypeID", "ExerciseTypeID"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ExerciseEventID", "ExerciseEventID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Text", "Text"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("ImageFileID", "ImageFileID"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("ImageFileURL", "ImageFileURL"));
        }
        #endregion

    #region Commands definition
    public enum Commands
    {
      RestoreBySearch          = 10,
      RestoreRandomBySearch    = 11
    }
    #endregion

    #region Get Commands
    protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
    {
      switch (CommandID)
      {
          case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
          case (int)Commands.RestoreRandomBySearch: return new Command_RestoreRandomBySearch();
      }
      
      return base.DoGetCommand(CommandID);
    }
    #endregion

    #region Additional Commands Classes
    class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.ExerciseAvatar>
    {
        public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.ExerciseAvatar.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

      protected override void InitializeParametrs()
      {
          Add(new Gemini.Core.BL.DBD.Param("ExerciseTypeID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
          Add(new Gemini.Core.BL.DBD.Param("ExerciseEventID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
      }

      protected override void InitializeCommandText()
      {
          _commandText = "PIZB1200_ExerciseAvatar_RestoreBySearch";
      }
    }

    class Command_RestoreRandomBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.ExerciseAvatar>
    {
        public Command_RestoreRandomBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.ExerciseAvatar.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

        protected override void InitializeParametrs()
        {
            Add(new Gemini.Core.BL.DBD.Param("ExerciseTypeID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            Add(new Gemini.Core.BL.DBD.Param("ExerciseEventID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
        }

        protected override void InitializeCommandText()
        {
            _commandText = "PIZB1200_ExerciseAvatar_RestoreRandomBySearch";
        }
    }
    #endregion
    }
}
